package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Vladimir Gordiychuk
 */
public class FlatMetricTypeEncoder {
    static void encodeMetricType(StockpileSerializer serializer, FlatEncoderState state, MetricType type) {
        if (state.lastType != type) {
            AllFields.METRIC_TYPE_ENCODER.writeValue(serializer, type.getNumber());
        }
        state.lastType = type;
    }

    static boolean tryDecodeMetricType(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.METRIC_TYPE_ENCODER.tag) {

            int num = AllFields.METRIC_TYPE_ENCODER.readValue(fieldTag, deserializer);
            state.lastType = MetricType.forNumber(num);
            return true;
        } else {
            return false;
        }
    }
}
