package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.StepColumn;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
class FlatStepEncoder {
    static int encodePointStep(StockpileSerializer serializer, FlatEncoderState state, long stepMillis) {
        StepColumn.validateOrThrow(stepMillis);

        int sameFieldMaskChange = 0;
        if (state.lastStepMillis == stepMillis) {
            sameFieldMaskChange = StepColumn.mask;
        } else {
            AllFields.STEP_ENCODER.writeValue(serializer, stepMillis);
        }
        state.lastStepMillis = stepMillis;
        return sameFieldMaskChange;
    }

    static boolean tryDecodePointStepMillis(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.STEP_ENCODER.tag) {
            state.lastStepMillis = AllFields.STEP_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else {
            return false;
        }
    }
}
