package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import java.util.Objects;

import ru.yandex.monlib.metrics.summary.SummaryDoubleSnapshot;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.StockpileColumn;

/**
 * @author Vladimir Gordiychuk
 */
public class FlatSummaryDoubleEncoder {
    static int encodeSummaryDouble(StockpileSerializer serializer, FlatEncoderState state, SummaryDoubleSnapshot summary) {
        if (Objects.equals(state.summaryDouble, summary)) {
            return StockpileColumn.DSUMMARY.mask();
        }

        AllFields.DSUMMARY_ENCODER.writeValue(serializer, summary);
        state.summaryDouble = summary;
        return 0;
    }

    static boolean tryDecodeSummaryDouble(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag != AllFields.DSUMMARY_ENCODER.tag()) {
            return false;
        }
        state.summaryDouble = AllFields.DSUMMARY_ENCODER.readValue(fieldTag, deserializer);
        return true;
    }
}
