package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import java.util.Objects;

import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.StockpileColumn;

/**
 * @author Vladimir Gordiychuk
 */
public class FlatSummaryInt64Encoder {
    static int encodeSummaryInt64(StockpileSerializer serializer, FlatEncoderState state, SummaryInt64Snapshot summary) {
        if (Objects.equals(state.summaryInt64, summary)) {
            return StockpileColumn.ISUMMARY.mask();
        }

        AllFields.ISUMMARY_ENCODER.writeValue(serializer, summary);
        state.summaryInt64 = summary;
        return 0;
    }

    static boolean tryDecodeSummaryInt64(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag != AllFields.ISUMMARY_ENCODER.tag()) {
            return false;
        }
        state.summaryInt64 = AllFields.ISUMMARY_ENCODER.readValue(fieldTag, deserializer);
        return true;
    }
}
