package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.TsColumn;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
class FlatTsEncoder {
    static int encodePointTsMillisPossiblySame(StockpileSerializer serializer, FlatEncoderState state, long tsMillis) {
        TsColumn.validateOrThrow(tsMillis);

        int sameFieldMaskChange = 0;
        if (state.lastTsMillis == tsMillis) {
            sameFieldMaskChange = TsColumn.mask;
        } else {
            AllFields.TS_RELATIVE_ENCODER.writeValue(serializer, tsMillis - state.lastTsMillis);
        }
        state.lastTsMillis = tsMillis;
        return sameFieldMaskChange;
    }

    static boolean tryDecodePointTsMillis(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.TS_RELATIVE_ENCODER.tag) {
            state.lastTsMillis = state.lastTsMillis + AllFields.TS_RELATIVE_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else {
            return false;
        }
    }
}
