package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.ValueColumn;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
class FlatValueEncoder {
    static int encodePointValue(StockpileSerializer serializer, FlatEncoderState state, double valueNum, long valueDenom) {
        ValueColumn.validateOrThrow(valueNum, valueDenom);

        int sameFieldMaskChange = 0;

        // This check looks like a cleaner approach rather than having multiple checks like isFinite, Math.rint(), etc.
        if (valueNum == state.lastValueNum) {
            sameFieldMaskChange = ValueColumn.mask;
        } else if (valueNum == (long) valueNum) {
            AllFields.VALUE_NUM_LONG_ENCODER.writeValue(serializer, (long) valueNum);
        } else {
            AllFields.VALUE_NUM_DOUBLE_ENCODER.writeValue(serializer, valueNum);
        }

        if (valueDenom == state.lastValueDenom) {
            sameFieldMaskChange |= ValueColumn.mask;
        } else {
            AllFields.VALUE_DENOM_ENCODER.writeValue(serializer, valueDenom);
        }

        state.lastValueNum = valueNum;
        state.lastValueDenom = valueDenom;

        return sameFieldMaskChange;
    }

    static boolean tryDecodePointValue(int fieldTag, StockpileDeserializer deserializer, FlatEncoderState state) {
        if (fieldTag == AllFields.VALUE_NUM_LONG_ENCODER.tag) {
            state.lastValueNum = AllFields.VALUE_NUM_LONG_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else if (fieldTag == AllFields.VALUE_NUM_DOUBLE_ENCODER.tag) {
            state.lastValueNum = AllFields.VALUE_NUM_DOUBLE_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else if (fieldTag == AllFields.VALUE_DENOM_ENCODER.tag) {
            state.lastValueDenom = AllFields.VALUE_DENOM_ENCODER.readValue(fieldTag, deserializer);
            return true;
        } else {
            return false;
        }
    }
}
