package ru.yandex.stockpile.client;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

import ru.yandex.stockpile.api.TReadRequest;
import ru.yandex.stockpile.api.TReadResponse;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class StopStrategyTest {

    @Test
    public void neverStop() throws Exception {
        StopStrategy strategy = StopStrategies.neverStop();
        for (int index = 1; index < 5; index++) {
            TReadRequest request = TReadRequest.getDefaultInstance();
            TReadResponse response = TReadResponse.getDefaultInstance();
            Attempt<TReadRequest, TReadResponse> attempt = new Attempt<>(index, request, response, 0);
            assertFalse(strategy.shouldStop(attempt));
        }
    }

    @Test
    public void alwaysStop() throws Exception {
        StopStrategy strategy = StopStrategies.alwaysStop();
        for (int index = 1; index < 5; index++) {
            TReadRequest request = TReadRequest.getDefaultInstance();
            TReadResponse response = TReadResponse.getDefaultInstance();
            Attempt<TReadRequest, TReadResponse> attempt = new Attempt<>(index, request, response, 0);
            assertTrue(strategy.shouldStop(attempt));
        }
    }

    @Test
    public void limitAttempt() throws Exception {
        StopStrategy strategy = StopStrategies.stopAfterAttempt(3);

        List<Attempt<TReadRequest, TReadResponse>> attempts = new ArrayList<>(4);
        for (int index = 1; index < 6; index++) {
            TReadRequest request = TReadRequest.getDefaultInstance();
            TReadResponse response = TReadResponse.getDefaultInstance();
            Attempt<TReadRequest, TReadResponse> attempt = new Attempt<>(index, request, response, 0);
            attempts.add(attempt);
        }

        assertTrue(strategy.shouldStop(attempts.get(0)));
        assertTrue(strategy.shouldStop(attempts.get(1)));
        assertTrue(strategy.shouldStop(attempts.get(2)));
        assertFalse(strategy.shouldStop(attempts.get(3)));
        assertFalse(strategy.shouldStop(attempts.get(4)));
    }
}
