package ru.yandex.stockpile.client.writeRequest.serializers;

import org.junit.Test;

import ru.yandex.solomon.codec.serializer.HeapStockpileSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.model.type.Histogram;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class DHistogramFieldSerializerTest {
    private final DHistogramFieldSerializer field = new DHistogramFieldSerializer(16);

    @Test
    public void serializeDeserializeBuckets() {
        var hist = histogram(new double[]{100, 200, 300}, new long[]{0, 5, 0}, 0);
        var result = deserialize(serialize(hist));
        assertEquals(hist, result);
    }

    @Test
    public void serializeDeserializeDenom() {
        var hist = histogram(new double[]{10, 20, 30}, new long[]{1, 2, 0}, 15_000);
        var result = deserialize(serialize(hist));
        assertEquals(15_000, result.getDenom());
        assertEquals(hist, result);
    }

    private byte[] serialize(Histogram histogram) {
        var serializer = new HeapStockpileSerializer();
        field.writeValue(serializer, histogram);
        return serializer.build();
    }

    private Histogram deserialize(byte[] content) {
        var deserializer = new StockpileDeserializer(content);
        int tag = FieldTagSerializer.readFieldTag(deserializer);
        return field.readValue(tag, deserializer);
    }

    public Histogram histogram(double[] bounds, long[] buckets, long denom) {
        return Histogram.newInstance(bounds, buckets).setDenom(denom);
    }
}
