package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;

import org.junit.Assert;
import org.junit.Test;

import ru.yandex.stockpile.client.writeRequest.serializers.ProtobufFieldSerializer;

/**
 * @author Stepan Koltsov
 */
public class AllFieldsTest {

    @Test
    public void uniqueFieldNumbers() {
        int[] fieldNumbers = Arrays.stream(AllFields.class.getDeclaredFields())
            .filter(AllFieldsTest::isStaticNonPrivate)
            .mapToInt(f -> {
                try {
                    ProtobufFieldSerializer serializer = (ProtobufFieldSerializer) f.get(null);
                    return serializer.fieldNumber();
                } catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            })
            .toArray();

        Assert.assertTrue(fieldNumbers.length > 0);

        Assert.assertEquals(fieldNumbers.length, Arrays.stream(fieldNumbers).distinct().count());
    }

    private static boolean isStaticNonPrivate(Field f) {
        return (f.getModifiers() & (Modifier.STATIC | Modifier.PRIVATE)) == Modifier.STATIC;
    }

}
