package ru.yandex.stockpile.client.writeRequest.serializers.flat;

import java.util.function.Consumer;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.solomon.codec.serializer.HeapStockpileSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.stockpile.client.writeRequest.serializers.FieldTagSerializer;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class FlatMetricTypeEncoderTest {
    private FlatEncoderState encodeState;
    private FlatEncoderState decodeState;
    private HeapStockpileSerializer s;
    private StockpileDeserializer d;

    @Before
    public void setUp() {
        encodeState = new FlatEncoderState();
        decodeState = new FlatEncoderState();
        s = new HeapStockpileSerializer();
        d = null;
    }

    @Test
    public void serializeDeserializeOne() {
        forEachKind(this::serialize);
        forEachKind(kind -> {
            assertThat(kind.name(), deserialize(), equalTo(kind));
        });
    }

    @Test
    public void serializeDeserializeSame() {
        serialize(MetricType.COUNTER);
        serialize(MetricType.COUNTER);
        serialize(MetricType.COUNTER);

        assertThat(deserialize(), equalTo(MetricType.COUNTER));
        assertThat(deserialize(), equalTo(MetricType.COUNTER));
        assertThat(deserialize(), equalTo(MetricType.COUNTER));
    }

    @Test
    public void skipWriteDefaultState() {
        serialize(MetricType.METRIC_TYPE_UNSPECIFIED);
        assertThat(s.buildByteString().size(), equalTo(0));
    }

    private void forEachKind(Consumer<MetricType> consumer) {
        for (MetricType type : MetricType.values()) {
            if (type == MetricType.UNRECOGNIZED || type == MetricType.METRIC_TYPE_UNSPECIFIED) {
                continue;
            }

            consumer.accept(type);
        }
    }

    private void serialize(MetricType type) {
        FlatMetricTypeEncoder.encodeMetricType(s, encodeState, type);
    }

    private MetricType deserialize() {
        if (d == null) {
            d = new StockpileDeserializer(s.build());
        }

        if (d.atEof()) {
            return decodeState.lastType;
        }

        int fieldTag = FieldTagSerializer.readFieldTag(d);
        FlatMetricTypeEncoder.tryDecodeMetricType(fieldTag, d, decodeState);
        return decodeState.lastType;
    }
}
