JAVA_LIBRARY(stockpile-client)

OWNER(g:solomon)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/contribs.inc)
INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/jdk.inc)

JAVA_SRCS(
    PACKAGE_PREFIX ru.yandex.stockpile.client
    SRCDIR src
    **/*.java
)

PEERDIR(
    solomon/protos/stockpile
    solomon/libs/java/grpc
    solomon/libs/java/selfmon
    solomon/libs/java/config
    solomon/libs/java/discovery
    solomon/libs/java/ts-model
    solomon/libs/java/ts-codec
    solomon/libs/java/ts-math
    solomon/libs/java/cluster-discovery
    solomon/libs/java/grpc-conf

    iceberg/commune-protobuf

    contrib/java/org/springframework/spring-beans
    contrib/java/org/springframework/spring-context

    # 3rd-party dependency
    contrib/java/org/slf4j/slf4j-api

    # Explicit dependency because without it not able create grpc server
    # Caused by: java.lang.ClassNotFoundException: com.google.instrumentation.trace.Tracing
    contrib/java/com/google/instrumentation/instrumentation-api/0.4.2

    # grpc-protobuf:1.18 depends on guava:25.1-android http://central.maven.org/maven2/io/grpc/grpc-protobuf/1.18.0/grpc-protobuf-1.18.0.pom
    # com.google.common.net.HostAndPort:getHostText() does not exists in guava:25.1-android
    contrib/java/com/google/guava/guava
)

LINT(base)
END()

RECURSE(benchmarks)
RECURSE_FOR_TESTS(ut)
