package ru.yandex.solomon.tracing;

import java.util.Map;

import io.jaegertracing.internal.metrics.Counter;
import io.jaegertracing.internal.metrics.Gauge;
import io.jaegertracing.internal.metrics.Timer;
import io.jaegertracing.spi.MetricsFactory;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Sergey Polovko
 */
final class MonlibMetricsFactory implements MetricsFactory {

    private final MetricRegistry registry;

    public MonlibMetricsFactory(MetricRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Counter createCounter(String name, Map<String, String> tags) {
        var counter = registry.counter(name, Labels.of(tags));
        return counter::add;
    }

    @Override
    public Gauge createGauge(String name, Map<String, String> tags) {
        GaugeInt64 gauge = registry.gaugeInt64(name, Labels.of(tags));
        return gauge::set;
    }

    @Override
    public Timer createTimer(String name, Map<String, String> tags) {
        Histogram histogram = registry.histogramRate(name, Labels.of(tags), Histograms.exponential(16, 2));
        return histogram::record;
    }
}
