package ru.yandex.solomon.codec.histogram.log;

import java.util.Arrays;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.bits.HeapBitBuf;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
abstract class AbstractStreamEncoder<S extends EncodeState> implements Encoder {
    protected abstract S createState();
    protected abstract void encode(BitBuf os, S state, LogHistogram histogram);

    @Override
    public byte[] encode(LogHistogram[] data) {
        BitBuf stream = new HeapBitBuf();
        S state = createState();

        for (LogHistogram histogram : data) {
            encode(stream, state, histogram);
        }

        return Arrays.copyOf(stream.array(), stream.read8Bits());
    }
}
