package ru.yandex.solomon.codec.histogram.log;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
class EncoderAsIs extends AbstractStreamEncoder {
    @Override
    public EncodeState createState() {
        return null;
    }

    @Override
    public void encode(BitBuf os, EncodeState state, LogHistogram histogram) {
        os.writeIntVarint8(histogram.getStartPower());
        os.writeLongVarint8(histogram.getCountZero());
        os.writeIntVarint8(histogram.countBucket());

        for (int index = 0; index < histogram.countBucket() ; index++) {
            os.writeDoubleBits(histogram.getBucketValue(index));
        }
    }
}
