package ru.yandex.solomon.codec.histogram.log;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
class EncoderAsIsProtobuf extends AbstractStreamEncoder {
    @Override
    public EncodeState createState() {
        return null;
    }

    @Override
    protected void encode(BitBuf os, EncodeState state, LogHistogram histogram) {
        for (byte b : LogHistogramConverter.toProtobut(histogram).toByteArray()) {
            os.write8Bits(b);
        }
    }
}
