package ru.yandex.solomon.codec.histogram.log;

import ru.yandex.misc.io.gzip.GzipUtils;
import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
class EncoderAsIsProtobufGzip extends AbstractStreamEncoder {
    @Override
    public EncodeState createState() {
        return null;
    }

    @Override
    public void encode(BitBuf os, EncodeState state, LogHistogram histogram) {
        byte[] compressed = GzipUtils.zip(LogHistogramConverter.toProtobut(histogram).toByteArray());
        for (byte b : compressed) {
            os.write8Bits(b);
        }
    }
}
