package ru.yandex.solomon.codec.histogram.log;

import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPOutputStream;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
class EncoderAsIsProtobufGzipBulk implements Encoder {
    @Override
    public byte[] encode(LogHistogram[] data) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutStream = new GZIPOutputStream(out);

            for (LogHistogram histogram : data) {
                gzipOutStream.write(toByteArray(histogram));
            }
            return out.toByteArray();
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private byte[] toByteArray(LogHistogram histogram) {
        return LogHistogramConverter.toProtobut(histogram).toByteArray();
    }
}
