package ru.yandex.solomon.codec.histogram.log;

import java.io.IOException;

import org.xerial.snappy.Snappy;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
class EncoderAsIsProtobufSnappy extends AbstractStreamEncoder {
    @Override
    public EncodeState createState() {
        return null;
    }

    @Override
    public void encode(BitBuf os, EncodeState state, LogHistogram histogram) {
        try {
            byte[] compressed = Snappy.compress(LogHistogramConverter.toProtobut(histogram).toByteArray());
            for (byte b : compressed) {
                os.write8Bits(b);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
