package ru.yandex.solomon.codec.histogram.log;

import java.io.ByteArrayOutputStream;

import org.xerial.snappy.SnappyOutputStream;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
class EncoderAsIsProtobufSnappyBulk implements Encoder {
    @Override
    public byte[] encode(LogHistogram[] data) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SnappyOutputStream snappyOutStream = new SnappyOutputStream(out);
            for (LogHistogram histogram : data) {
                snappyOutStream.write(LogHistogramConverter.toProtobut(histogram).toByteArray());
            }
            return out.toByteArray();
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }
}
