package ru.yandex.solomon.codec.histogram.log;

import java.util.Arrays;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.compress.CompressStreamFactory;
import ru.yandex.solomon.codec.compress.TimeSeriesOutputStream;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
class EncoderGorilla implements Encoder  {

    @Override
    public byte[] encode(LogHistogram[] data) {
        AggrPoint point = new AggrPoint();
        point.tsMillis = System.currentTimeMillis();

        int mask = StockpileColumn.TS.mask() | StockpileColumn.LOG_HISTOGRAM.mask();
        TimeSeriesOutputStream stream = CompressStreamFactory.createOutputStream(MetricType.DGAUGE, mask);
        try {
            for (LogHistogram histogram :  data) {
                point.logHistogram = histogram;
                stream.writePoint(mask, point);
            }

            BitBuf compressedData = stream.getCompressedData();
            return Arrays.copyOf(compressedData.array(), compressedData.bytesSize());
        } finally {
            stream.close();
        }
    }
}
