package ru.yandex.solomon.codec.histogram.log;

import java.util.stream.IntStream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.salmon.proto.StockpileCanonicalProto;
import ru.yandex.solomon.model.type.LogHistogram;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class LogHistogramConverter {
    static StockpileCanonicalProto.LogHistogram toProtobut(LogHistogram histogram) {
        StockpileCanonicalProto.LogHistogram.Builder builder =
            StockpileCanonicalProto.LogHistogram.newBuilder()
                .setStartPower(histogram.getStartPower())
                .setCountZero(histogram.getCountZero());

        IntStream.range(0, histogram.countBucket())
            .mapToDouble(histogram::getBucketValue)
            .forEach(builder::addBuckets);

        return builder.build();
    }
}
