package ru.yandex.solomon.codec.value;

import java.time.Instant;
import java.util.Random;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.archive.MetricArchiveMutable;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.ValueColumn;

/**
 * results:
 *    - deriv 29451981 bits ~ 3.510 MiB
 *    - nu/de 39373949 bits ~ 4.693 MiB
 *
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ValueEncoderSizeBenchmark {

    public static void main(String[] args) {
        Random random = new Random(0x6637d537ab263L);

        MetricArchiveMutable b0 = new MetricArchiveMutable();
        MetricArchiveMutable b1 = new MetricArchiveMutable();

        long ts0 = Instant.parse("2017-02-01T12:13:14Z").toEpochMilli();

        long prev = 10_000_000;

        for (int i = 0; i < 1_000_000; ++i) {
            AggrPoint p0 = new AggrPoint();
            AggrPoint p1 = new AggrPoint();

            p0.setTsMillis(ts0 + i * 15000);
            p1.setTsMillis(ts0 + i * 15000);

            long n = prev + random.nextInt(10000);
            long d = n - prev;

            // store raw value as it is (but in double, storing it as long will be even more effective)
            p0.setValue((double) n, ValueColumn.DEFAULT_DENOM);

            // store delta in numerator and stepMillis(15s) in denominator
            p1.setValue(d, 15000);

            b0.addRecord(p0);
            b1.addRecord(p1);
        }

        System.out.println("deriv " + b0.toImmutable().bytesCount());
        System.out.println("nu/de " + b1.toImmutable().bytesCount());
    }

}
