package ru.yandex.solomon.codec;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.compress.CompressStreamFactory;
import ru.yandex.solomon.codec.compress.TimeSeriesInputStream;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class BinaryAggrGraphDataListIterator extends AggrGraphDataListIterator {
    private final TimeSeriesInputStream inputStream;
    private final int recordCount;

    public BinaryAggrGraphDataListIterator(
            MetricType type,
            int columnSetMask,
            BitBuf buffer,
            int recordCount)
    {
        super(columnSetMask);
        this.inputStream = CompressStreamFactory.createInputStream(type, columnSetMask, buffer);
        this.recordCount = recordCount;
    }

    @Override
    public boolean next(AggrPoint target) {
        if (!inputStream.hasNext()) {
            inputStream.close();
            return false;
        }

        inputStream.readPoint(columnSetMask(), target);
        return true;
    }

    @Override
    public int estimatePointsCount() {
        return recordCount;
    }
}
