package ru.yandex.solomon.codec.archive.header;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Delete before given timestamp before contained multiarchive.
 *
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class DeleteBeforeField {
    public static final long KEEP = 0;
    public static final long DELETE_ALL = 1;

    public static long merge(long a, long b) {
        if (a == DELETE_ALL || b == DELETE_ALL) {
            return DELETE_ALL;
        }
        if (a == KEEP) {
            return b;
        }
        if (b == KEEP) {
            return a;
        }
        return Long.max(a, b);
    }
}
