package ru.yandex.solomon.codec.archive.serializer;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.archive.header.DeleteBeforeField;
import ru.yandex.solomon.codec.archive.header.MetricHeader;
import ru.yandex.solomon.codec.serializer.SelfContainedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.protobuf.MetricType;

/**
 * @author Maksim Leonov
 */
@ParametersAreNonnullByDefault
public abstract class MetricHeaderSerializer implements SelfContainedSerializer<MetricHeader> {

    public static final MetricHeaderSerializer I = new ImplV1();

    private static class ImplV1 extends MetricHeaderSerializer {

        private static final int DERIV_BIT = 0;
        private static final int DELETE_BEFORE_BIT = 1;

        private static int setBit(int v, int bit, boolean value) {
            if (value) {
                return v | (1 << bit);
            } else {
                return v & (~(1 << bit));
            }
        }

        private static boolean isBitSet(int v, int bit) {
            return (v & (1 << bit)) != 0;
        }

        @Override
        public void serializeWithLength(MetricHeader metricHeader, StockpileSerializer serializer) {
            int b = 0;
            b = setBit(b, DELETE_BEFORE_BIT, metricHeader.getDeleteBefore() != DeleteBeforeField.KEEP);
            serializer.writeByte(b);
            if (metricHeader.getDeleteBefore() != DeleteBeforeField.KEEP) {
                serializer.writeVarint64(metricHeader.getDeleteBefore());
            }
            serializer.writeVarint32(metricHeader.getOwnerProjectId());
            serializer.writeVarint32(metricHeader.getOwnerShardId());
            serializer.writeVarint32(metricHeader.getDecimPolicyId());
            serializer.writeVarint32(metricHeader.getType().getNumber());
        }

        @Override
        public MetricHeader deserializeWithLength(StockpileDeserializer deserializer) {
            int b = deserializer.readByteUnsigned();
            boolean deleteBeforeBit = isBitSet(b, DELETE_BEFORE_BIT);
            long deleteBefore;
            if (deleteBeforeBit) {
                deleteBefore = deserializer.readVarint64();
            } else {
                deleteBefore = DeleteBeforeField.KEEP;
            }
            int ownerProjectId = deserializer.readVarint32();
            int ownerShardId = deserializer.readVarint32();
            short decimPolicyId = deserializer.readVarint16();

            MetricType type = MetricType.forNumber(deserializer.readVarint32());

            return new MetricHeader(
                    deleteBefore,
                    ownerProjectId,
                    ownerShardId,
                    decimPolicyId,
                    type);
        }
    }
}
