package ru.yandex.solomon.codec.archive.serializer;

import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.model.point.column.StockpileColumnSet;
import ru.yandex.solomon.model.point.column.StockpileColumnSetType;

/**
 * @author Stepan Koltsov
 */
public class StockpileColumnSetSerializer {

    private static final int maxColumnSet = StockpileColumnSet.maxMask;

    private static void validateColumnSet(@StockpileColumnSetType int columnSet) {
        if (columnSet > maxColumnSet || columnSet < 0) {
            throw new IllegalArgumentException("Invalid column set: " + columnSet);
        }
    }

    public static void writeColumnSet(StockpileSerializer os, @StockpileColumnSetType int columnSet) {
        validateColumnSet(columnSet);
        os.writeFixed32(columnSet);
    }

    public static int readColumnSet(StockpileDeserializer is) {
        final int columnSet = is.readFixed32();
        validateColumnSet(columnSet);
        return columnSet;
    }

}
