package ru.yandex.solomon.codec.archive.stats;

import java.util.Collections;
import java.util.Map;
import java.util.OptionalDouble;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.doubles.AggregateFunctionType;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ArchiveStats {
    public static final ArchiveStats empty = new ArchiveStats(Collections.emptyMap());

    private final double min;
    private final double max;
    private final double avg;
    private final double last;
    @Nullable // deriv only
    private final Double sum;

    public ArchiveStats(Map<AggregateFunctionType, Double> stats) {
        this.min = stats.getOrDefault(AggregateFunctionType.MIN, Double.NaN);
        this.max = stats.getOrDefault(AggregateFunctionType.MAX, Double.NaN);
        this.avg = stats.getOrDefault(AggregateFunctionType.AVG, Double.NaN);
        this.last = stats.getOrDefault(AggregateFunctionType.LAST, Double.NaN);
        this.sum = stats.getOrDefault(AggregateFunctionType.SUM, Double.NaN);
    }

    public ArchiveStats(double min, double max, double avg, double last, Double sum) {
        this.min = min;
        this.max = max;
        this.avg = avg;
        this.last = last;
        this.sum = sum;
    }

    public double getMin() {
        return min;
    }

    public double getMax() {
        return max;
    }

    public double getAvg() {
        return avg;
    }

    public double getLast() {
        return last;
    }

    @Nullable
    public Double getSum() {
        return sum;
    }

    public OptionalDouble fetch(AggregateFunctionType fn) {
        switch (fn) {
            case AVG: return OptionalDouble.of(avg);
            case LAST: return OptionalDouble.of(last);
            case MAX: return OptionalDouble.of(max);
            case MIN: return OptionalDouble.of(min);
            case SUM: return sum != null ? OptionalDouble.of(sum) : OptionalDouble.empty();
            default: return OptionalDouble.empty();
        }
    }
}
