package ru.yandex.solomon.codec.bits;

/**
 * @author Stepan Koltsov
 */
public class BitArray {

    private static final byte[] EMPTY_ARRAY = new byte[0];

    public static byte[] allocate(long size) {
        return (size == 0) ? EMPTY_ARRAY : new byte[arrayLengthForBits(size)];
    }

    public static int arrayLengthForBits(long size) {
        return div8Exact(size + 7);
    }

    public static void setBit(byte[] array, long bit) {
        array[div8(bit)] |= (1 << mod8(bit));
    }

    public static boolean isBitSet(byte[] array, long bit) {
        return isBitSet(array[div8(bit)], mod8(bit));
    }

    public static boolean isBitSet(byte bits, int bit) {
        return (bits & (1 << bit)) != 0;
    }

    public static int div8(long bit) {
        return (int) (bit >>> 3);
    }

    public static int div8Exact(long bit) {
        return Math.toIntExact(bit >>> 3);
    }

    public static int mod8(long bit) {
        return (int) (bit & 7);
    }

    public static long toBits(int bytes, int usedBytesInLastByte) {
        long bits = (long) bytes << 3;
        if (usedBytesInLastByte == 0) {
            return bits;
        }
        return bits - (long) Byte.SIZE + (long) usedBytesInLastByte;
    }

    public static long toBits(int bytes) {
        return (long) bytes << 3;
    }

    public static void checkSize(byte[] array, long lengthBits) {
        final int lengthBytes = BitArray.arrayLengthForBits(lengthBits);
        if (lengthBytes > array.length) {
            throw new IndexOutOfBoundsException("lengthBytes(" + lengthBytes + ") > array.length(" + array.length + ")");
        }
    }
}
