package ru.yandex.solomon.codec.bits;

import ru.yandex.solomon.staffOnly.annotations.LinkedOnRootPage;
import ru.yandex.solomon.staffOnly.annotations.ManagerMethod;

/**
 * @author Vladimir Gordiychuk
 */
@LinkedOnRootPage("BitBufAllocator")
public class BitBufAllocator {
    private static boolean USE_POOLED = false;

    public static BitBuf buffer(int initialCapacity) {
        if (USE_POOLED) {
            return new PooledHeapBitBuf(initialCapacity);
        }
        return new HeapBitBuf(new byte[initialCapacity], 0);
    }

    public static BitBuf buffer(byte[] array, long bits) {
        if (USE_POOLED) {
            int bytes = BitArray.arrayLengthForBits(bits);
            var buffer = PooledHeapBitBuf.ALLOCATOR.heapBuffer(bytes).writeBytes(array, 0, bytes);
            return new PooledHeapBitBuf(buffer, bits);
        }

        return new HeapBitBuf(array, bits);
    }

    @ManagerMethod
    public void usePooledBuffers() {
        USE_POOLED = true;
    }

    @ManagerMethod
    public void useHeapBuffers() {
        USE_POOLED = false;
    }

    @Override
    public String toString() {
        return "BitBufAllocator{POOLED=" + USE_POOLED + "}";
    }
}
