package ru.yandex.solomon.codec.bits;

import javax.annotation.ParametersAreNonnullByDefault;

import it.unimi.dsi.fastutil.booleans.BooleanArrayList;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class BitStreamUtils {

    private static boolean parseBit(char c) {
        switch (c) {
            case '1': return true;
            case '0': return false;
            default: throw new IllegalArgumentException("unknown bit to parse: " + c);
        }
    }

    static boolean[] parseBits(String bits) {
        BooleanArrayList r = new BooleanArrayList();
        for (int i = 0; i < bits.length(); ++i) {
            char c = bits.charAt(i);
            if (c == ' ') {
                continue;
            }
            r.add(parseBit(c));
        }
        return r.toBooleanArray();
    }

    static BitBuf parse(String bits) {
        return parse(bits, BitBufAllocator.buffer(bits.length()));
    }

    static BitBuf parse(String bits, BitBuf target) {
        for (boolean b : parseBits(bits)) {
            target.writeBit(b);
        }
        return target;
    }
}
