package ru.yandex.solomon.codec.bits;

import javax.annotation.Nonnull;

import ru.yandex.bolts.collection.Cf;

/**
 * @author Vladimir Gordiychuk
 */
public class ReadOnlyHeapBitBuf extends HeapBitBuf {
    public static final BitBuf EMPTY = new ReadOnlyHeapBitBuf(Cf.ByteArray.emptyArray(), 0);

    public ReadOnlyHeapBitBuf(@Nonnull byte[] array, long lengthBits) {
        super(array, lengthBits);
    }

    public ReadOnlyHeapBitBuf(@Nonnull byte[] array, long readerIndex, long writerIndex) {
        super(array, readerIndex, writerIndex);
    }

    @Override
    public void ensureBytesCapacity(int minBytesCapacity) {
        throwReadOnly();
    }

    @Override
    public void ensureBytesCapacity(int pos, int minBytesCapacity) {
        throwReadOnly();
    }

    @Override
    public void writeBit(boolean bit) {
        throwReadOnly();
    }

    @Override
    public void write8Bits(byte bits) {
        throwReadOnly();
    }

    @Override
    public void write32Bits(int bits) {
        throwReadOnly();
    }

    @Override
    public void write64Bits(long bits) {
        throwReadOnly();
    }

    @Override
    public void writeBits(byte bits, int count) {
        throwReadOnly();
    }

    @Override
    public void writeBits(int bits, int count) {
        throwReadOnly();
    }

    @Override
    public void writeBits(long bits, int count) {
        throwReadOnly();
    }

    @Override
    public void writeIntVarint1N(int n, int max) {
        throwReadOnly();
    }

    @Override
    public void alignToByte() {
        throwReadOnly();
    }

    void throwReadOnly() {
        throw new UnsupportedOperationException("ReadOnly BitBuf");
    }
}
