package ru.yandex.solomon.codec.bits;

import javax.annotation.Nonnull;

import io.netty.buffer.ByteBuf;

import ru.yandex.bolts.collection.Cf;

/**
 * @author Vladimir Gordiychuk
 */
public class ReadOnlyPooledHeapBitBuf extends PooledHeapBitBuf {
    public static final BitBuf EMPTY = new ReadOnlyHeapBitBuf(Cf.ByteArray.emptyArray(), 0);

    public ReadOnlyPooledHeapBitBuf(@Nonnull ByteBuf buf, long lengthBits) {
        super(buf, lengthBits);
    }

    public ReadOnlyPooledHeapBitBuf(@Nonnull ByteBuf buf, long readerIndex, long writerIndex) {
        super(buf, readerIndex, writerIndex);
    }

    @Override
    public void ensureBytesCapacity(int minBytesCapacity) {
        throwReadOnly();
    }

    @Override
    public void ensureBytesCapacity(int pos, int minBytesCapacity) {
        throwReadOnly();
    }

    @Override
    public void writeBit(boolean bit) {
        throwReadOnly();
    }

    @Override
    public void write8Bits(byte bits) {
        throwReadOnly();
    }

    @Override
    public void write32Bits(int bits) {
        throwReadOnly();
    }

    @Override
    public void write64Bits(long bits) {
        throwReadOnly();
    }

    @Override
    public void writeBits(byte bits, int count) {
        throwReadOnly();
    }

    @Override
    public void writeBits(int bits, int count) {
        throwReadOnly();
    }

    @Override
    public void writeBits(long bits, int count) {
        throwReadOnly();
    }

    @Override
    public void writeIntVarint1N(int n, int max) {
        throwReadOnly();
    }

    @Override
    public void alignToByte() {
        throwReadOnly();
    }

    void throwReadOnly() {
        throw new UnsupportedOperationException("ReadOnly BitBuf");
    }
}
