package ru.yandex.solomon.codec.compress;

import javax.annotation.Nonnull;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.model.point.column.StockpileColumn;

/**
 * @author Stepan Koltsov
 */
public class CommandEncoder {

    private static final int fieldNumberBits = 5;

    static void encodeColumnNumber(BitBuf os, int fieldNumber) {
        os.writeBits(fieldNumber, fieldNumberBits);
    }

    static int decodeColumnNumber(BitBuf is) {
        return is.readBitsToInt(fieldNumberBits);
    }

    @Nonnull
    static StockpileColumn decodeColumn(BitBuf is) {
        int number = decodeColumnNumber(is);
        return StockpileColumn.byNumberOrThrow(number);
    }

    static void encodeColumn(BitBuf os, StockpileColumn column) {
        encodeColumnNumber(os, column.index());
    }

    public static void encodeCommandPrefix(BitBuf os, StockpileColumn column) {
        writeCommandFlag(os, true);
        encodeColumn(os, column);
    }

    static void encodeEndOfCommands(BitBuf os) {
        writeCommandFlag(os, false);
    }

    private static void writeCommandFlag(BitBuf os, boolean flag) {
        os.writeBit(flag);
    }

    static boolean readCommandFlag(BitBuf deserializer) {
        return deserializer.readBit();
    }
}
