package ru.yandex.solomon.codec.compress;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.bits.ReadOnlyHeapBitBuf;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.solomon.model.point.AggrPointData;
import ru.yandex.solomon.model.point.column.StockpileColumnSet;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
final class EmptyTimeSeriesOutputStream implements TimeSeriesOutputStream {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(EmptyTimeSeriesOutputStream.class);
    public static final EmptyTimeSeriesOutputStream INSTANCE = new EmptyTimeSeriesOutputStream();

    private EmptyTimeSeriesOutputStream() {
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE;
    }

    @Override
    public void ensureCapacity(int columnSet, int capacity) {
    }

    @Override
    public void ensureCapacity(int bytes) {
    }

    @Override
    public void writePoint(int columnSet, AggrPointData aggrPoint) {
        throw new IllegalStateException(
            "Empty output does not support write operation, but you tried to write "
                + new StockpileColumnSet(columnSet)
                + " "
                + aggrPoint
        );
    }

    @Override
    public int recordCount() {
        return 0;
    }

    @Override
    public int frameBytesCount() {
        return 0;
    }

    @Override
    public int frameRecordCount() {
        return 0;
    }

    @Override
    public boolean closeFrame() {
        return false;
    }

    @Override
    public void forceCloseFrame() {
    }

    @Override
    public long getLatestFrameIdx() {
        return 0;
    }

    @Override
    public long getLastTsMillis() {
        return 0;
    }

    @Override
    public long getLastFrameIdx() {
        return 0;
    }

    @Override
    public BitBuf getCompressedData() {
        return ReadOnlyHeapBitBuf.EMPTY;
    }

    @Override
    public TimeSeriesOutputStream copy() {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public int bytesCount() {
        return 0;
    }
}
