package ru.yandex.solomon.codec.compress;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.model.point.AggrPointData;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface TimeSeriesOutputStream extends AutoCloseable, MemMeasurable {
    void ensureCapacity(int columnSet, int capacity);
    void ensureCapacity(int bytes);
    void writePoint(int columnSet, AggrPointData aggrPoint);
    BitBuf getCompressedData();

    /**
     * Copy state and encode buffer to new instance
     */
    TimeSeriesOutputStream copy();

    @Override
    void close();

    /**
     * @return used count bytes to store time series
     */
    int bytesCount();

    int recordCount();

    /**
     * @return last frame bytes count
     */
    int frameBytesCount();

    /**
     * @return last frame records count
     */
    int frameRecordCount();

    /**
     * close last frame if enough data for it
     */
    boolean closeFrame();

    /**
     * close last frame event not enough bytes for it
     */
    void forceCloseFrame();

    long getLatestFrameIdx();

    /**
     * @return ts millis of latest write point
     */
    long getLastTsMillis();

    long getLastFrameIdx();
}
