package ru.yandex.solomon.codec.compress;

import ru.yandex.solomon.codec.bits.BitBuf;

/**
 * @author Vladimir Gordiychuk
 */
public class VarintEncoder {
    private static int[] COUNT_BIT_PER_MODE = new int[] { 0, 4, 8, 12, 16, 24, 32, 64 };
    private static int[] COUNT_BIT_PER_MODE_32 = new int[] { 0, 4, 8, 12, 32 };

    public static void writeVarintMode64(BitBuf out, long v) {
        if (v == 0) {
            out.writeBit(false);
        } else if ((v & ~0xf) == 0) {
            out.writeBits(v << 2 | 1, 6);
        } else if ((v & ~0xff) == 0) {
            out.writeBits(v << 3 | 3, 11);
        } else if ((v & ~0xf_ff) == 0) {
            out.writeBits(v << 4 | 7, 16);
        } else if ((v & ~0xff_ff) == 0) {
            out.writeBits(v << 5 | 15, 21);
        } else if ((v & ~0xff_ff_ff) == 0) {
            out.writeBits(v << 6 | 31, 30);
        } else if ((v & ~0xff_ff_ff_ffL) == 0) {
            out.writeBits(v << 7 | 63, 39);
        } else {
            out.write8Bits(0x7F);
            out.write64Bits(v);
        }
    }

    public static void writeVarintMode32(BitBuf out, int v) {
        if (v == 0) {
            out.writeBit(false);
        } else if ((v & ~0xf) == 0) {
            out.writeBits(v << 2 | 1, 6);
        } else if ((v & ~0xff) == 0) {
            out.writeBits(v << 3 | 3, 11);
        } else if ((v & ~0xf_ff) == 0) {
            out.writeBits(v << 4 | 7, 16);
        } else {
            out.writeBits(Integer.toUnsignedLong(v) << 5 | 15, 37);
        }
    }

    public static long readVarintMode64(BitBuf in) {
        return in.readBitsToLong(COUNT_BIT_PER_MODE[in.readIntVarint1N(8)]);
    }

    public static int readVarintMode32(BitBuf in) {
        return in.readBitsToInt(COUNT_BIT_PER_MODE_32[in.readIntVarint1N(5)]);
    }

}
