package ru.yandex.solomon.codec.compress.doubles;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.bits.BitBuf;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class DenomEncoder {
    /** Denom is 0 */
    private static final int subDenom0 = 0;
    /** Denom is multiple of 1000 */
    private static final int subDenomM1000 = 1;
    /** Denom is multiple of 1000 */
    private static final int subDenomM1 = 2;

    private static final int commandBits = 3;

    public static long read(BitBuf stream) {
        int sub = stream.readBitsToInt(commandBits);
        switch (sub) {
            case subDenom0:
                return 0;
            case subDenomM1:
                return stream.readLongVarint8();
            case subDenomM1000:
                return stream.readLongVarint8() * 1000;
            default:
                throw new RuntimeException("unknown command: " + sub);
        }
    }

    public static void write(BitBuf stream, long denom) {
        if (denom == 0) {
            stream.writeBits(subDenom0, commandBits);
        } else if (denom % 1000 == 0) {
            stream.writeBits(subDenomM1000, commandBits);
            stream.writeLongVarint8(denom / 1000);
        } else {
            stream.writeBits(subDenomM1, commandBits);
            stream.writeLongVarint8(denom);
        }
    }
}
