package ru.yandex.solomon.codec.compress.frames;

import java.time.Instant;

import ru.yandex.misc.dataSize.DataSize;

/**
 * @author Vladimir Gordiychuk
 */
public class Frame {
    public long pos;
    public long size;
    public long firstTsMillis;

    /**
     * Zero if unknown because frame not closed and not provided outside
     */
    public long lastTsMillis;

    /**
     * Zero if unknown because frame not closed and not provided outside
     */
    public int records;

    /**
     * Frame doesn't have footer and can be append to other only as a last frame
     */
    public boolean closed;

    @Override
    public String toString() {
        return "Frame{" +
            "pos=" + pos +
            ", size=" + DataSize.shortString(size) +
            ", firstTsMillis=" + Instant.ofEpochMilli(firstTsMillis) +
            ", lastTsMillis=" + Instant.ofEpochMilli(lastTsMillis) +
            ", records=" + DataSize.shortString(records) +
            ", closed=" + closed +
            '}';
    }
}
