package ru.yandex.solomon.codec.compress.frames;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.compress.FrameIterator;
import ru.yandex.solomon.codec.compress.VarintEncoder;

/**
 * @author Vladimir Gordiychuk
 */
public class TimeSeriesFrameIteratorImpl implements TimeSeriesFrameIterator {
    private final BitBuf buffer;
    private final long lastFrameLastTsMillis;
    private final int lastFrameRecords;
    private final FrameIterator it;

    public TimeSeriesFrameIteratorImpl(BitBuf buffer) {
        this(buffer, 0, 0);
    }

    public TimeSeriesFrameIteratorImpl(BitBuf buffer, long lastFrameLastTsMillis, int lastFrameRecords) {
        this.buffer = buffer;
        this.lastFrameLastTsMillis = lastFrameLastTsMillis;
        this.lastFrameRecords = lastFrameRecords;
        this.it = new FrameIterator(buffer);
    }

    @Override
    public boolean next(Frame frame) {
        if (!it.next()) {
            return false;
        }

        frame.pos = it.headerIndex();
        frame.size = it.frameSize();

        buffer.readerIndex(it.payloadIndex());
        frame.firstTsMillis = buffer.read64Bits();

        if (it.hasFooter()) {
            buffer.readerIndex(it.footerIndex());
            frame.lastTsMillis = buffer.read64Bits();
            frame.records = VarintEncoder.readVarintMode32(buffer);
            frame.closed = true;
        } else {
            frame.lastTsMillis = lastFrameLastTsMillis;
            frame.records = lastFrameRecords;
            frame.closed = false;
        }

        return true;
    }
}
