package ru.yandex.solomon.codec.compress.histograms;

import java.util.Arrays;

import com.google.protobuf.CodedInputStream;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.compress.AbstractTimeSeriesInputStream;
import ru.yandex.solomon.codec.compress.GorillaEncoder;
import ru.yandex.solomon.codec.compress.VarintEncoder;
import ru.yandex.solomon.codec.compress.doubles.DenomEncoder;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.type.Histogram;

/**
 * @author Vladimir Gordiychuk
 */
public class HistogramTimeSeriesInputStreamV4 extends AbstractTimeSeriesInputStream {
    private double[] prevBounds = Cf.DoubleArray.emptyArray();
    private byte[] prevBoundsTrailingZeros = Cf.ByteArray.emptyArray();
    private byte[] prevBoundsLeadingZeros = Cf.ByteArray.emptyArray();
    private long[] prevBuckets = Cf.LongArray.emptyArray();
    private int size = 0;
    private long prevDenom = 0;

    public HistogramTimeSeriesInputStreamV4(BitBuf in) {
        super(in);
    }

    @Override
    protected void readCommand(StockpileColumn column, BitBuf stream) {
        int size = stream.readIntVarint8();
        if (size > this.size) {
            prevBounds = Arrays.copyOf(prevBounds, size);
            prevBoundsTrailingZeros = Arrays.copyOf(prevBoundsTrailingZeros, size);
            prevBoundsLeadingZeros = Arrays.copyOf(prevBoundsLeadingZeros, size);
            prevBuckets = Arrays.copyOf(prevBuckets, size);
        }
        this.size = size;
        GorillaEncoder.State state = new GorillaEncoder.State();
        for (int index = 0; index < size; index++) {
            state.prev = prevBounds[index];
            state.prevTrailingZeros = prevBoundsTrailingZeros[index];
            state.prevLeadingZeros = prevBoundsLeadingZeros[index];

            GorillaEncoder.read(stream, state);

            prevBounds[index] = state.prev;
            prevBoundsTrailingZeros[index] = state.prevTrailingZeros;
            prevBoundsLeadingZeros[index] = state.prevLeadingZeros;
        }
        this.prevDenom = DenomEncoder.read(stream);
    }

    @Override
    protected void readValue(BitBuf stream, AggrPoint point) {
        for (int index = 0; index < size; index++) {
            long delta = CodedInputStream.decodeZigZag64(VarintEncoder.readVarintMode64(stream));
            long value = delta + prevBuckets[index];
            prevBuckets[index] = value;
        }

        if (point.histogram == null) {
            point.histogram = Histogram.newInstance();
        } else {
            point.histogram.reset();
        }

        point.histogram = point.histogram.copyFrom(prevBounds, prevBuckets, size).setDenom(prevDenom);
    }

    @Override
    protected void resetAdditionalState() {
        Arrays.fill(prevBounds, 0);
        Arrays.fill(prevBoundsTrailingZeros, (byte) 0);
        Arrays.fill(prevBoundsLeadingZeros, (byte) 0);
        Arrays.fill(prevBuckets, 0);
        size = 0;
        prevDenom = 0;
    }
}
