package ru.yandex.solomon.codec.compress.longs;

import com.google.protobuf.CodedInputStream;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.compress.AbstractTimeSeriesInputStream;
import ru.yandex.solomon.codec.compress.VarintEncoder;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StockpileColumn;

/**
 * @author Vladimir Gordiychuk
 */
public class CounterTimeSeriesInputStream extends AbstractTimeSeriesInputStream {
    private long prevValue;
    private long prevValueDelta;

    public CounterTimeSeriesInputStream(BitBuf in) {
        super(in);
    }

    @Override
    protected void readCommand(StockpileColumn column, BitBuf stream) {
        // no op
    }

    @Override
    protected void readValue(BitBuf in, AggrPoint point) {
        long deltaOfDelta = CodedInputStream.decodeZigZag64(VarintEncoder.readVarintMode64(in));
        long delta = prevValueDelta + deltaOfDelta;
        long value = prevValue + delta;
        point.longValue = value;
        this.prevValue = value;
        this.prevValueDelta = delta;
    }

    @Override
    protected void resetAdditionalState() {
        prevValue = 0;
        prevValueDelta = 0;
    }
}
