package ru.yandex.solomon.codec.compress.longs;

import com.google.protobuf.CodedInputStream;

import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.compress.AbstractTimeSeriesInputStream;
import ru.yandex.solomon.codec.compress.VarintEncoder;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.LongValueColumn;
import ru.yandex.solomon.model.point.column.StockpileColumn;

/**
 * @author Vladimir Gordiychuk
 */
public class IGaugeTimeSeriesInputStream extends AbstractTimeSeriesInputStream {
    private long prevLongValue = LongValueColumn.DEFAULT_VALUE;

    public IGaugeTimeSeriesInputStream(BitBuf in) {
        super(in);
    }

    @Override
    protected void readCommand(StockpileColumn column, BitBuf stream) {
        // no op
    }

    @Override
    protected void readValue(BitBuf stream, AggrPoint point) {
        long delta = CodedInputStream.decodeZigZag64(VarintEncoder.readVarintMode64(stream));
        long value = prevLongValue + delta;
        point.longValue = prevLongValue = value;
    }

    @Override
    protected void resetAdditionalState() {
        prevLongValue = LongValueColumn.DEFAULT_VALUE;
    }
}
