package ru.yandex.solomon.codec.compress.summaries;

/**
 * @author Vladimir Gordiychuk
 */
public enum SummaryColumn {
    COUNT(0),
    SUM(1),
    MIN(2),
    MAX(3),
    LAST(4);

    private int mask;

    SummaryColumn(int index) {
        this.mask = 1 << index;
    }

    public boolean present(int mask) {
        return (mask & this.mask) != 0;
    }

    public int getMask() {
        return mask;
    }
}


