package ru.yandex.solomon.codec.compress.summaries;

import com.google.protobuf.CodedInputStream;

import ru.yandex.monlib.metrics.summary.ImmutableSummaryDoubleSnapshot;
import ru.yandex.solomon.codec.bits.BitBuf;
import ru.yandex.solomon.codec.compress.AbstractTimeSeriesInputStream;
import ru.yandex.solomon.codec.compress.GorillaEncoder;
import ru.yandex.solomon.codec.compress.VarintEncoder;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.type.SummaryDouble;

/**
 * @author Vladimir Gordiychuk
 */
public class SummaryDoubleTimeSeriesInputStreamV3 extends AbstractTimeSeriesInputStream {
    private int mask = 0;
    private long prevCount = 0;
    private GorillaEncoder.State prevSum = new GorillaEncoder.State();
    private GorillaEncoder.State prevMin = new GorillaEncoder.State();
    private GorillaEncoder.State prevMax = new GorillaEncoder.State();
    private GorillaEncoder.State prevLast = new GorillaEncoder.State();

    public SummaryDoubleTimeSeriesInputStreamV3(BitBuf in) {
        super(in);
    }

    @Override
    protected void readCommand(StockpileColumn column, BitBuf stream) {
        mask = stream.readBitsToInt(5);
    }

    @Override
    protected void readValue(BitBuf stream, AggrPoint point) {
        if (SummaryColumn.COUNT.present(mask)) {
            prevCount += CodedInputStream.decodeZigZag64(VarintEncoder.readVarintMode64(stream));
        }

        double sum = ImmutableSummaryDoubleSnapshot.EMPTY.getSum();
        if (SummaryColumn.SUM.present(mask)) {
            sum = GorillaEncoder.read(stream, prevSum);
        }

        double min = ImmutableSummaryDoubleSnapshot.EMPTY.getMin();
        if (SummaryColumn.MIN.present(mask)) {
            min = GorillaEncoder.read(stream, prevMin);
        }

        double max = ImmutableSummaryDoubleSnapshot.EMPTY.getMax();
        if (SummaryColumn.MAX.present(mask)) {
            max = GorillaEncoder.read(stream, prevMax);
        }

        double last = ImmutableSummaryDoubleSnapshot.EMPTY.getLast();
        if (SummaryColumn.LAST.present(mask)) {
            last = GorillaEncoder.read(stream, prevLast);
        }
        point.summaryDouble = SummaryDouble.orNew(point.summaryDouble)
            .setCount(prevCount)
            .setSum(sum)
            .setMin(min)
            .setMax(max)
            .setLast(last);
    }

    @Override
    protected void resetAdditionalState() {
        mask = 0;
        prevCount = 0;
        prevSum.reset();
        prevMin.reset();
        prevMax.reset();
        prevLast.reset();
    }
}
