package ru.yandex.solomon.codec.serializer;

import java.util.Arrays;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;

import ru.yandex.solomon.util.protobuf.ByteStrings;

/**
 * @author Stepan Koltsov
 */
public class ByteStringsStockpile {

    public static ByteString concat(ByteString[] byteStrings) {
        return Arrays.stream(byteStrings)
            .reduce(ByteString.EMPTY, ByteString::concat);
    }

    public static ByteString[] split(ByteString bytes, int maxSize) {
        return ByteStrings.split(bytes, maxSize);
    }

    public static ByteString[] unsafeWrapAndSplit(byte[] bytes, int maxSize) {
        return split(unsafeWrap(bytes), maxSize);
    }

    public static ByteString unsafeWrap(byte[] bytes) {
        return unsafeWrap(bytes, 0, bytes.length);
    }

    public static ByteString unsafeWrap(byte[] bytes, int offset, int length) {
        return UnsafeByteOperations.unsafeWrap(bytes, offset, length);
    }
}
