package ru.yandex.solomon.codec.serializer;

import java.util.Arrays;
import java.util.Random;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.api.EProjectId;

import static ru.yandex.stockpile.api.EProjectId.UNKNOWN;
import static ru.yandex.stockpile.api.EProjectId.UNRECOGNIZED;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class OwnerField {

    public static final int UNKNOWN_SHARD_ID = 0;

    // for faster lookup
    private static final EProjectId[] PROJECT_IDS = projectsMap();

    private static EProjectId[] projectsMap() {
        int max = Arrays.stream(EProjectId.values())
            .filter(p -> p != UNRECOGNIZED)
            .mapToInt(EProjectId::getNumber)
            .max()
            .getAsInt() + 1;

        // build map { id -> project }
        EProjectId[] result = new EProjectId[max];
        for (int i = 0; i < max; i++) {
            EProjectId p = EProjectId.forNumber(i);
            result[i] = (p == null) ? UNKNOWN : p;
        }
        return result;
    }

    public static EProjectId forNumberOrUnknown(int n) {
        if (n >= 0 && n < PROJECT_IDS.length) {
            return PROJECT_IDS[n];
        }
        return UNKNOWN;
    }

    public static EProjectId random(Random rnd) {
        return PROJECT_IDS[rnd.nextInt(PROJECT_IDS.length)];
    }

    public static int mergeOwnerField(int prev, int update) {
        if (update != 0) {
            return update;
        } else {
            return prev;
        }
    }
}
