package ru.yandex.solomon.codec.serializer;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StockpileFormatVersionSerializer {

    public static final Impl impl = new Impl();

    public static class Impl implements SelfContainedSerializer<StockpileFormat> {

        @Override
        public void serializeWithLength(StockpileFormat stockpileFormat, StockpileSerializer serializer) {
            serializer.writeVarint32(stockpileFormat.getFormat());
        }

        @Override
        public StockpileFormat deserializeWithLength(StockpileDeserializer deserializer) {
            return StockpileFormat.byNumber(deserializer.readVarint32());
        }
    }

}
