package ru.yandex.solomon.codec.serializer;

import java.io.OutputStream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.memory.layout.MemMeasurable;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface StockpileSerializer extends MemMeasurable {
    void ensureCapacity(int bytes);
    OutputStream asOutputStream();
    void writeBoolean(boolean b);
    void writeByte(int b);
    void writeByte(byte b);
    void writeFixed64(long value);
    void writeFixed32(int value);
    void writeVarint16(short value);
    void writeVarint32(int value);
    void writeVarint64(long value);
    void writeDouble(double v);
    void writeBytes(byte[] bytes, int offset, int length);
    void writeBytes(byte[] bytes);
    int size();
}
