package ru.yandex.solomon.codec.serializer;

import java.util.EnumMap;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class WithVersionHeaderSerializer<A> implements NakedSerializer<A> {

    private final EnumMap<StockpileFormat, NakedSerializer<A>> byVersion;
    private final Function<A, StockpileFormat> writeFormat;

    public WithVersionHeaderSerializer(
        NakedSerializerFactoryByFormat<A> byVersion, Function<A, StockpileFormat> writeFormat)
    {
        this.byVersion = StockpileFormat.makeMap(byVersion::makeSerializer);
        this.writeFormat = writeFormat;
    }

    @Override
    public void serializeToEof(A a, StockpileSerializer serializer) {
        StockpileFormat format = writeFormat.apply(a);
        StockpileFormatVersionSerializer.impl.serializeWithLength(format, serializer);
        byVersion.get(format).serializeToEof(a, serializer);
    }

    @Override
    public A deserializeToEofImpl(StockpileDeserializer deserializer) {
        StockpileFormat format = StockpileFormatVersionSerializer.impl.deserializeWithLength(deserializer);
        return byVersion.get(format).deserializeToEof(deserializer);
    }

}
