package ru.yandex.solomon.codec.serializer.array;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.type.array.ObjectArrayType;
import ru.yandex.solomon.codec.serializer.SelfContainedSerializer;
import ru.yandex.solomon.codec.serializer.StockpileDeserializer;
import ru.yandex.solomon.codec.serializer.StockpileSerializer;
import ru.yandex.solomon.codec.serializer.naked.NakedSerializer;
import ru.yandex.solomon.util.collection.array.ArrayBuilder;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ArrayNakedSerializer<E> implements NakedSerializer<E[]> {
    private final ObjectArrayType<E> arrayType;
    private final SelfContainedSerializer<E> elementSerializer;

    public ArrayNakedSerializer(Class<E> elementType, SelfContainedSerializer<E> elementSerializer) {
        this.elementSerializer = elementSerializer;
        arrayType = new ObjectArrayType<>(elementType);
    }

    @Override
    public void serializeToEof(E[] es, StockpileSerializer serializer) {
        for (E e : es) {
            elementSerializer.serializeWithLength(e, serializer);
        }
    }

    @Override
    public E[] deserializeToEofImpl(StockpileDeserializer deserializer) {
        ArrayBuilder<E> r = new ArrayBuilder<>(arrayType.emptyArray());
        while (!deserializer.atEof()) {
            r.add(elementSerializer.deserializeWithLength(deserializer));
        }
        return r.build();
    }
}
